/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.StringTokenizer;
import oracle.ias.cache.group.GroupCommunication;
import oracle.ias.cache.group.GroupException;
import oracle.ias.cache.group.HttpPacket;
import oracle.ias.cache.group.Packet;

public class HttpHandler {
    public static int COPY_BUFFER_SIZE = 4096;
    public static int RCV_BUFFER_SIZE = 4096;
    byte[] m_rcv_buf;
    byte[] m_header_buf;
    int m_position;
    int m_header_position;
    int m_bytes_read;
    HashMap m_headers;
    OutputStream m_os;
    InputStream m_is;

    public HttpHandler(InputStream inputStream, OutputStream outputStream) throws IOException, GroupException {
        if (outputStream == null || inputStream == null) {
            throw new GroupException(GroupCommunication.EXP_GRP_SOCKETINITFAIL);
        }
        this.m_os = outputStream;
        this.m_is = inputStream;
        this.m_position = 0;
        this.m_header_position = 0;
        this.m_rcv_buf = new byte[RCV_BUFFER_SIZE];
        this.m_header_buf = new byte[RCV_BUFFER_SIZE];
        this.m_bytes_read = 0;
        this.m_headers = new HashMap();
    }

    public void write(HttpPacket httpPacket) throws IOException, GroupException {
        InputStream inputStream = null;
        byte[] byArray = httpPacket.getHeaders();
        this.m_os.write(byArray, 0, byArray.length);
        byArray = httpPacket.getPacketBuffer();
        this.m_os.write(byArray, 0, byArray.length);
        if (httpPacket.hasAttachedFile() || httpPacket.hasInputStream()) {
            if (httpPacket.hasAttachedFile()) {
                FileInputStream fileInputStream = new FileInputStream(httpPacket.getAttachedFile());
                inputStream = fileInputStream;
            } else if (httpPacket.hasInputStream()) {
                inputStream = httpPacket.getInputStream();
            }
            byArray = new byte[COPY_BUFFER_SIZE];
            while (true) {
                int n;
                if (inputStream == null && GroupCommunication.shouldLog(15)) {
                    GroupCommunication.log("Internal error: InputStream is null");
                }
                if ((n = inputStream.read(byArray)) == -1) break;
                this.m_os.write(byArray, 0, n);
            }
        }
        this.m_os.flush();
    }

    public Packet read() throws IOException, GroupException {
        Closeable closeable;
        Object object;
        Packet packet = null;
        this.m_headers.clear();
        this.m_header_position = 0;
        while (this.m_header_position < this.m_header_buf.length && (this.m_header_position < 4 || this.m_header_buf[this.m_header_position - 4] != 13 || this.m_header_buf[this.m_header_position - 3] != 10 || this.m_header_buf[this.m_header_position - 2] != 13 || this.m_header_buf[this.m_header_position - 1] != 10)) {
            int n = this.m_is.read();
            if (n == -1) {
                return null;
            }
            this.m_header_buf[this.m_header_position] = (byte)n;
            ++this.m_header_position;
        }
        if (this.m_header_position == RCV_BUFFER_SIZE) {
            throw new GroupException(GroupCommunication.EXP_GRP_INVALID_STREAM);
        }
        this.parseHeaders();
        String string = (String)this.m_headers.get(HttpPacket.s_packet_length_header);
        if (string != null) {
            int n = new Integer(string);
            byte[] byArray = new byte[n];
            this.m_bytes_read = 0;
            while (this.m_bytes_read != n) {
                int n2 = this.m_is.read(byArray, this.m_bytes_read, n - this.m_bytes_read);
                if (n2 == -1) {
                    throw new GroupException(GroupCommunication.EXP_GRP_INVALID_STREAM);
                }
                this.m_bytes_read += n2;
            }
            object = new ByteArrayInputStream(byArray);
            closeable = new ObjectInputStream((InputStream)object);
            try {
                packet = (Packet)((ObjectInputStream)closeable).readObject();
            }
            catch (Exception exception) {
                throw new GroupException("Can't deserialize the Packet.", exception);
            }
        } else {
            if (GroupCommunication.shouldLog(15)) {
                GroupCommunication.log("Packet length header not found.");
            }
            throw new GroupException(GroupCommunication.EXP_GRP_INVALID_STREAM);
        }
        String string2 = (String)this.m_headers.get(HttpPacket.s_file_length_header);
        int n = 0;
        if (string2 != null) {
            n = new Integer(string2);
        }
        if (n != 0) {
            object = GroupCommunication.getTempFilePath();
            closeable = new FileOutputStream((String)object);
            while (n > 0) {
                this.m_bytes_read = n >= this.m_rcv_buf.length ? this.m_is.read(this.m_rcv_buf) : this.m_is.read(this.m_rcv_buf, 0, n);
                if (this.m_bytes_read == -1) {
                    throw new GroupException(GroupCommunication.EXP_GRP_INVALID_STREAM);
                }
                n -= this.m_bytes_read;
                ((FileOutputStream)closeable).write(this.m_rcv_buf, 0, this.m_bytes_read);
            }
            if (n > 0) {
                throw new GroupException(GroupCommunication.EXP_GRP_INVALID_STREAM);
            }
            packet.setAttachedFileName((String)object);
        }
        return packet;
    }

    private void parseHeaders() throws IOException, GroupException {
        int n = this.m_position;
        byte[] byArray = new byte[this.m_header_position];
        System.arraycopy(this.m_header_buf, 0, byArray, 0, this.m_header_position);
        String string = new String(byArray);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        String string2 = stringTokenizer.nextToken();
        if (!string2.equals(HttpPacket.s_request_line)) {
            if (GroupCommunication.shouldLog(3)) {
                GroupCommunication.log("Invalid HTTP request information: " + string2);
            }
            throw new GroupException(GroupCommunication.EXP_GRP_INVALID_HTTP);
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, HttpPacket.s_separator);
            if (!stringTokenizer2.hasMoreTokens()) continue;
            String string4 = stringTokenizer2.nextToken();
            String string5 = string3.substring(string4.length() + 2);
            this.m_headers.put(string4, string5);
        }
    }
}

